% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MethPed_dataset.R
\docType{data}
\name{MethPed_sample}
\alias{MethPed_sample}
\title{Sample dataset to MethPed package.}
\format{A data frame with 468821 probes and 2 tumor samples}
\usage{
data(MethPed_sample)
}
\value{
DNA Methylation beta-values
}
\description{
Methylation beta-values generated with the Infinium HumanMethylation450 BeadChips (Illumina).
}
\examples{
#################### Loading and view sample data
data(MethPed_sample)
head(MethPed_sample)

#################### Check dimention of sample data
dim(MethPed_sample)  # Check number of probes and samples in data

#################### Checking missing value in the data
missingIndex <- checkNA(MethPed_sample)

}
\references{
[1] Anna Danielsson, Szilárd Nemes, Magnus Tisell, Birgitta Lannering, Claes Nordborg, Magnus Sabel, and Helena Carén. "MethPed: A DNA Methylation Classifier Tool for the Identification of Pediatric Brain Tumor Subtypes". Clinical Epigenetics 2015, 7:62, 2015
}
\seealso{
See \url{http://www.clinicalepigeneticsjournal.com/content/7/1/62} for more details.
}
\keyword{data}

