% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retentionIndexing.R
\name{indexRtime}
\alias{indexRtime}
\title{Convert retention times to retention indices}
\usage{
indexRtime(x, y, FUN = rtiLinear, ...)
}
\arguments{
\item{x}{\code{numeric} vector with retention times}

\item{y}{\code{data.frame}data.frame containing two columns, where the first
holds the retention times of the indexing substances and the second the
actual index value}

\item{FUN}{\code{function} function defining how the conversion is performed,
default is linear interpolation}

\item{...}{additional parameter used by \code{FUN}}
}
\value{
\code{numeric} vector of same length as x with retention indices. Values
floating point decimals. If integer values shall be used conversion has
to be performed manually
}
\description{
\code{indexRtime} uses a list of known substances to convert retention times (RTs)
to retention indices (RIs). By this retention information is normalized
for differences in experimental settings, such as gradient delay volume,
dead volume or flow rate. By default linear interpolation is performed,
other ways of calculation can supplied as function.
}
\examples{

rti <- data.frame(rtime = c(1,2,3),
rindex = c(100,200,300))
rtime <- c(1.5, 2.5)
indexRtime(rtime, rti)

}
\author{
Michael Witting
}
