# MetaboAnnotation

[![Project Status: Active – The project has reached a stable, usable state and is being actively developed.](https://www.repostatus.org/badges/latest/active.svg)](https://www.repostatus.org/#active)
[![R-CMD-check-bioc](https://github.com/RforMassSpectrometry/MetaboAnnotation/workflows/R-CMD-check-bioc/badge.svg)](https://github.com/RforMassSpectrometry/MetaboAnnotation/actions?query=workflow%3AR-CMD-check-bioc)
[![codecov](https://codecov.io/gh/rformassspectrometry/MetaboAnnotation/branch/main/graph/badge.svg?token=RLMRUJGOQD)](https://codecov.io/gh/rformassspectrometry/MetaboAnnotation)
[![license](https://img.shields.io/badge/license-Artistic--2.0-brightgreen.svg)](https://opensource.org/licenses/Artistic-2.0)
[![years in bioc](http://bioconductor.org/shields/years-in-bioc/MetaboAnnotation.svg)](https://bioconductor.org/packages/release/bioc/html/MetaboAnnotation.html)
[![Ranking by downloads](http://bioconductor.org/shields/downloads/release/MetaboAnnotation.svg)](https://bioconductor.org/packages/stats/bioc/MetaboAnnotation/)
[![build release](http://bioconductor.org/shields/build/release/bioc/MetaboAnnotation.svg)](https://bioconductor.org/checkResults/release/bioc-LATEST/MetaboAnnotation/)
[![build devel](http://bioconductor.org/shields/build/devel/bioc/MetaboAnnotation.svg)](https://bioconductor.org/checkResults/devel/bioc-LATEST/MetaboAnnotation/)

High level functions to assist in annotation of (metabolomics) data sets. These
include functions to perform simple tentative annotations based on mass matching
but also functions to consider m/z and retention times for annotation of LC-MS
features given that respective reference values are available. In addition, the
function provides high-level functions to simplify matching of LC-MS/MS spectra
against spectral libraries and objects and functionality to represent and manage
such matched data.

For more information see the package
[homepage](https://rformassspectrometry.github.io/MetaboAnnotation).


# Installation

The package can be installed with

```r
install.packages("BiocManager")
BiocManager::install("MetaboAnnotation")
```


# Contributions

Contributions are highly welcome and should follow the [contribution
guidelines](https://rformassspectrometry.github.io/RforMassSpectrometry/articles/RforMassSpectrometry.html#contributions).
Also, please check the coding style guidelines in the [RforMassSpectrometry
vignette](https://rformassspectrometry.github.io/RforMassSpectrometry/articles/RforMassSpectrometry.html).
