% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variableGenes.R
\name{variableGenes}
\alias{variableGenes}
\title{Identify a highly variable gene set}
\usage{
variableGenes(
  dat,
  i = 1,
  exp_labels,
  min_recurrence = length(unique(exp_labels)),
  downsampling_size = 10000
)
}
\arguments{
\item{dat}{SummarizedExperiment object containing gene-by-sample
expression matrix.}

\item{i}{default value 1; non-zero index value of assay containing the matrix data}

\item{exp_labels}{character vector that denotes the source (Study ID) of
each sample.}

\item{min_recurrence}{Number of studies across which a gene must be detected
as highly variable to be kept. By default, only genes that are variable
across all studies are kept (intersection).}

\item{downsampling_size}{Downsample each study to downsampling_size
samples without replacement. If set to 0 or value exceeds dataset size,
no downsampling is applied.}
}
\value{
The output is a vector of gene names that are highly variable in
every experiment (intersect)
}
\description{
Identifies genes with high variance compared to their median expression
(top quartile) within each experimentCertain function
}
\examples{
data(mn_data)
var_genes = variableGenes(dat = mn_data, exp_labels = mn_data$study_id)
var_genes

}
