% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainModel.R
\name{trainModel}
\alias{trainModel}
\title{Pretrains model for the unsupervised version of MetaNeighbor}
\usage{
trainModel(var_genes, dat, i = 1, study_id, cell_type)
}
\arguments{
\item{var_genes}{vector of high variance genes.}

\item{dat}{SummarizedExperiment object containing gene-by-sample
expression matrix.}

\item{i}{default value 1; non-zero index value of assay containing the matrix
data}

\item{study_id}{a vector that lists the Study (dataset) ID for each sample}

\item{cell_type}{a vector that lists the cell type of each sample}
}
\value{
The output is a gene-by-cluster matrix that contains all the
information necessary to run MetaNeighborUS from a pre-trained model.
}
\description{
When comparing clusters to a large reference dataset, this function
summarizes the gene-by-cell matrix into a much smaller highly variable
gene-by-cluster matrix which can be fed as training data into MetaNeighborUS,
resulting in substantial time and memory savings.
}
\examples{
data(mn_data)
var_genes = variableGenes(dat = mn_data, exp_labels = mn_data$study_id)
trained_model = trainModel(var_genes = var_genes,
                           dat = mn_data,
                           study_id = mn_data$study_id,
                           cell_type = mn_data$cell_type)
celltype_NV = MetaNeighborUS(trained_model = trained_model,
                             dat = mn_data,
                             study_id = mn_data$study_id,
                             cell_type = mn_data$cell_type)
celltype_NV

}
