% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topHits.R
\name{topHits}
\alias{topHits}
\title{Find reciprocal top hits}
\usage{
topHits(cell_NV, dat, i = 1, study_id, cell_type, threshold = 0.95)
}
\arguments{
\item{cell_NV}{matrix of celltype-to-celltype AUROC scores
(output from \code{\link{MetaNeighborUS}})}

\item{dat}{a SummarizedExperiment object containing gene-by-sample
expression matrix.}

\item{i}{default value 1; non-zero index value of assay containing the matrix
data}

\item{study_id}{a vector that lists the Study (dataset) ID for each sample}

\item{cell_type}{a vector that lists the cell type of each sample}

\item{threshold}{default value 0.95. Must be between [0,1]}
}
\value{
Function returns a dataframe with cell types that are either reciprocal best 
matches, and/or those with AUROC values greater than or equal to threshold 
value
}
\description{
Identifies reciprocal top hits and high scoring cell type pairs. This
function only look for the overall top hit for each cell type. We strongly
recommend using topHitsByStudy instead, which looks for top hits in each
target study, providing a more comprehensive view of replicability.
}
\examples{
data(mn_data)
var_genes = variableGenes(dat = mn_data, exp_labels = mn_data$study_id)
celltype_NV = MetaNeighborUS(var_genes = var_genes, 
                             dat = mn_data, 
                             study_id = mn_data$study_id,
                             cell_type = mn_data$cell_type)
top_hits = topHits(cell_NV = celltype_NV,
                   dat = mn_data,
                   study_id = mn_data$study_id,
                   cell_type = mn_data$cell_type,
                   threshold = 0.9)
top_hits

}
\seealso{
\code{\link{topHitsByStudy}}
}
