% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_clusters.R
\name{plotMetaClusters}
\alias{plotMetaClusters}
\title{Plot meta-cluster badges, each badge is a small AUROC heatmap restricted to
a specific meta-cluster.}
\usage{
plotMetaClusters(
  meta_clusters,
  best_hits,
  reorder = FALSE,
  cex = 1,
  study_cols = NULL,
  auroc_breaks = c(0, 0.5, 0.7, 0.9, 0.95, 0.99, 1),
  auroc_cols = (grDevices::colorRampPalette(c("white", "blue")))(length(auroc_breaks) -
    1)
)
}
\arguments{
\item{meta_clusters}{Meta-cluster list generated by extractMetaClusters.}

\item{best_hits}{Matrix of AUROCs used to extract meta-clusters.}

\item{reorder}{Reorder datasets by similarity for each badge? By default,
the same dataset ordering is used for each badge.}

\item{cex}{Size factor controling label size.}

\item{study_cols}{Named vector where values are RGB colors and names are
unique study identifiers (corresponding to study_id).
If NULL, a default color palette is used.}

\item{auroc_breaks}{Numeric vector used to bin AUROC values for color coding.}

\item{auroc_cols}{Vector containing RGB colors used to encode AUROC levels. 
The length of auroc_cols must correspond to the length of auroc_breaks - 1.}
}
\description{
Plot meta-cluster badges, each badge is a small AUROC heatmap restricted to
a specific meta-cluster.
}
