% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_visualization.R
\name{plotClusterGraph}
\alias{plotClusterGraph}
\title{Plot cluster graph generated with makeClusterGraph.}
\usage{
plotClusterGraph(
  graph,
  study_id = NULL,
  cell_type = NULL,
  size_factor = 1,
  label_cex = 0.2 * size_factor,
  legend_cex = 2,
  study_cols = NULL
)
}
\arguments{
\item{graph}{Graph in igraph format generated by makeClusterGraph.}

\item{study_id}{Vector with study IDs provided to MetaNeighborUS to compute
AUROCs stored in graph (used to compute cluster size). If NULL, all nodes
have medium size.}

\item{cell_type}{Vector with cell type labels provided to MetaNeighborUS
to compute AUROCs stored in graph (used to compute cluster size). If NULL,
all nodes have medium size.}

\item{size_factor}{Numeric value controling the size of nodes and edges.}

\item{label_cex}{Numeric value controling the size of cell type labels.}

\item{legend_cex}{Numeric value controling the size of the legend.}

\item{study_cols}{Named vector where values are RGB colors and names are
unique study identifiers. If NULL, a default color palette is used.}
}
\description{
In this visualization, edges are colored in black when AUROC > 0.5 and
orange when AUROC < 0.5, edge width scales linearly with AUROC.
Edges are oriented from training cluster towards
test cluster. A black bidirectional edge indicates that two clusters are
reciprocal top matches.
Node radius reflects cluster size (small: up to 10 cells,
medium: up to 100 cells, large: all other clusters).
}
