% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotBPlot}
\alias{plotBPlot}
\title{Plot Bean Plot, showing how replicability of cell types depends on gene sets.}
\usage{
plotBPlot(nv_mat, hvg_score = NULL, cex = 1)
}
\arguments{
\item{nv_mat}{A rectangular AUROC matrix as returned by MetaNeighbor,
where each row is a gene set and each column is a cell type.}

\item{hvg_score}{Named vector with AUROCs obtained from a set of Highly
Variable Genes (HVGs). The names must correspond to cell types from nv_mat.
If specified, the HVG score is  highlighted in red.}

\item{cex}{Size factor for row and column labels.}
}
\description{
Plot Bean Plot, showing how replicability of cell types depends on gene sets.
}
\examples{
data("mn_data")
data("GOmouse")
library(SummarizedExperiment)
AUROC_scores = MetaNeighbor(dat = mn_data,
                            experiment_labels = as.numeric(factor(mn_data$study_id)),
                            celltype_labels = metadata(colData(mn_data))[["cell_labels"]],
                            genesets = GOmouse,
                            bplot = FALSE)
plotBPlot(AUROC_scores)

}
