% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singular_val.R
\name{plot_singular_values}
\alias{plot_singular_values}
\title{Generate Singular Value Plots for Each Dataset.}
\usage{
plot_singular_values(count, meta)
}
\arguments{
\item{count}{The integrated count table of taxa by samples. The
\code{count} parameter should be provided as either a \code{matrix} or a
\code{data.frame}.}

\item{meta}{The integrated meta table \code{meta} contains a column named ``batch''
which stores batch id.}
}
\value{
A list of ggplot objects displaying the singular values for each dataset.
}
\description{
This function produces singular value plots for each input dataset to assess
the validity of the low-rank assumption. A rapid decay in the singular values
indicates that the dataset can be effectively approximated by matrix factorization.
}
\examples{
 data(exampleData)
 O = exampleData$O
 meta = exampleData$meta
 plot_singular_values(O, meta)

}
