% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MetaDICT.R
\name{MetaDICT}
\alias{MetaDICT}
\title{Microbiome data integration method via shared dictionary learning.}
\usage{
MetaDICT(
  count,
  meta,
  covariates = "all",
  tree = NULL,
  taxonomy = NULL,
  distance_matrix = NULL,
  tax_level = NULL,
  customize_parameter = FALSE,
  alpha = 0.1,
  beta = 0.01,
  normalization = "uq",
  max_iter = 10000,
  imputation = FALSE,
  verbose = TRUE,
  optim_trace = FALSE
)
}
\arguments{
\item{count}{The integrated count table (taxa-by-sample matrix).
Should be provided as either a \code{matrix} or a \code{data.frame}.}

\item{meta}{The integrated meta table containing sample information
and batch IDs. The data must include a column named 'batch' containing all batch IDs. The row names of the meta should match the sample names in the count table.}

\item{covariates}{The covariates used in data integration. Default is \code{"all"}.}

\item{tree}{The phylogenetic tree (optional if a distance matrix or taxonomy is provided).}

\item{taxonomy}{The taxonomy table (optional if a distance matrix or phylogenetic tree is provided). The row names of the taxonomy table should match the taxa names in the count table.}

\item{distance_matrix}{A \code{matrix} measuring the dissimilarity of taxa.
Default is \code{NULL}, in which case MetaDICT generates a distance matrix
based on phylogenetic and taxonomic information.}

\item{tax_level}{The taxonomic level of the count table.}

\item{customize_parameter}{A logical variable. Set to \code{TRUE} if the
\code{alpha} and \code{beta} parameters are customized. If \code{FALSE},
MetaDICT determines these parameters based on the number of covariates.}

\item{alpha}{A parameter controlling the rank of the final corrected count table.
A larger \code{alpha} leads to a lower-rank shared dictionary.}

\item{beta}{A parameter controlling the smoothness of the estimated measurement efficiency.
A larger \code{beta} results in more similar measurement efficiencies across taxa.}

\item{normalization}{The normalization method. Options are \code{"Upper quantile"}, \code{"RSim"} or \code{"TSS"}.
Set to \code{NULL} if normalization is not needed.}

\item{max_iter}{The maximum number of iterations for the optimization process. Default is \code{10000}.}

\item{imputation}{A logical variable. Whether to allow MetaDICT to perform imputation
based on dictionary learning results. Default is \code{FALSE}.}

\item{verbose}{A logical variable. Whether to generate verbose output. Default is \code{TRUE}.}

\item{optim_trace}{A logical variable. Whether to print optimization steps. Default is \code{FALSE}.}
}
\value{
A \code{list} with the following components:
\item{\code{count}}{ (\code{data.frame}) – The corrected count table.
Rows represent taxa, and columns represent samples.}
\item{\code{D}}{ (\code{matrix}) – The estimated shared dictionary.}
\item{\code{R}}{ (\code{matrix}) – The estimated sample representation.}
\item{\code{w}}{ (\code{matrix}) – The estimated measurement efficiency.
Rows represent datasets, and columns represent taxa.}
\item{\code{meta}}{ (\code{data.frame}) – The meta table used in the covariate balancing step.}
\item{\code{dist_mat}}{ (\code{matrix}) – The distance matrix measuring taxa dissimilarity.}
}
\description{
A method for microbiome data integration. This method is designed to
remove batch effects and preserve biological variation while integrating heterogeneous datasets.
MetaDICT can better avoid overcorrection when unobserved confounding variables are present.
}
\details{
MetaDICT is a two-step approach. It initially estimates the batch effects by covariate balancing,
then refines the estimation via shared dictionary learning.
}
\examples{
 data(exampleData)
 O = exampleData$O
 meta = exampleData$meta
 dist_mat = exampleData$dist_mat
 metadict_res = MetaDICT(O, meta, distance_matrix = dist_mat)

}
