% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine.R
\name{threshold}
\alias{threshold}
\title{Threshold the statistical adjacency or spectral similarity matrices}
\usage{
threshold(
  am,
  type = c("threshold", "top1", "top2", "mean"),
  args,
  values = c("all", "min", "max"),
  na.rm = TRUE
)
}
\arguments{
\item{am}{`AdjacencyMatrix` object of `type` `"statistical"` as 
created from the function `statistical` OR `AdjacencyMatrix` 
object of the type "structural" containing spectral similarity adjacency 
matrices, that were added by `addSpectSimil()`. The object will contain the
adjacency matrices in the `assay` slot.}

\item{type}{`character`, either `"threshold"`, `"top1"`, `"top2"` or
`"mean"`}

\item{args}{`list`. Depending on the `type` arguments the list element
will be different. 

In the case of `type == "threshold"`, `args` has the 
entry `filter` (`character` of length 1). The character vector will specify the 
kind of filtering applied to the adjacency matrices. Elements in `filter`
will refer to the `assayNames`, e.g. 
`list(filter = "pearson_coef > 0.8")` will retain all edges with Pearson
correlation coefficients > 0.8. 
`list(filter = "pearson_coef > 0.8 & spearman_coef > 0.5")` will retain all 
edges with Pearson correlation coefficients > 0.8 AND Spearman correlation
coefficients > 0.5. 
`list(filter = "abs(pearson_coef) > 0.8 & spearman_coef > 0.5")` will retain all 
edges with Pearson correlation coefficients > 0.8 or < -0.8 AND Spearman 
correlation coefficients > 0.5.

In the case of `type == "top1"`, `type == "top2"`, or `type == "mean"`, 
`args` has the entry `n` (`numeric` of length 1), that 
denotes the number of top ranks written to the
consensus matrix. Optionally, `args` has the entry `abs` which will take 
absolute values of the coefficients (will default to `FALSE` if `args$abs` 
is not specified).}

\item{values}{`character`, take from the adjacency matrix all values ("all"),
the minimum of the pairs ("min"), \eqn{a^* _{ij} = min(a_{ij}, a_{ji})},
or the maximum ("max"), \eqn{a^*_{ij} = max(a_{ij}, a_{ji})}}

\item{na.rm}{`logical`, if set to `TRUE`, the `NA`s in the assay slots will 
not be taken into account when creating the `"consensus"` assay. If set 
to `FALSE`, the `NA`s will be taken into account and might be passed to the
`"consensus"` assay (or `"binary"` if input was type "structural"). 
If `FALSE` the user can set the filter e.g. to 
`(ggm_coef > 0 | is.na(ggm_coef))`, when there are `NA`s in 
`ggm_coef` to disregard `NA`s.}
}
\value{
`AdjacencyMatrix` object containing a binary adjacency matrix
given the links supported by the `type` and the `args` (in the slot 
`"consensus"` if the input was type "statistical" or in the slot
`"binary"` if it was type "structural". 
The object will furthermore contain the supplied data input,
i.e. all assays from `am`. The slot `threshold` is set to `TRUE`.
}
\description{
The function `threshold` takes as input an `AdjacencyMatrix` object 
containing adjacency matrices
as returned from the function `statistical` OR the `AdjacencyMatrix` 
object of the type "structural" containing spectral similarity adjacency 
matrices, that were added by `addSpectSimil()`.Depending on the `type`
argument, `threshold` will identify the strongest link that are
lower or higher a certain threshold (`type = "threshold"`) or
identify the top `n` links (`type` either `"top1"`, `"top2"` or `"mean"`).
It will return this kind of information as a binary matrix in the form
of an `AdjacencyMatrix` object.
}
\details{
`values` has to be set carefully depending on if the `AdjacencyMatrix` object
`am` is `directed` or not.

In the case of `type == "threshold"`, `args` has the 
entry `filter` (`character` of length 1). The character vector will specify the 
kind of filtering applied to the adjacency matrices. Elements in `filter`
will refer to the `assayNames`, e.g. 
`list(filter = "pearson_coef > 0.8")` will retain all edges with Pearson
correlation coefficients > 0.8. 
`list(filter = "pearson_coef > 0.8 & spearman_coef > 0.5")` will retain all 
edges with Pearson correlation coefficients > 0.8 AND Spearman correlation
coefficients > 0.5. 
`list(filter = "abs(pearson_coef) > 0.8 & spearman_coef > 0.5")` will retain all 
edges with Pearson correlation coefficients > 0.8 and < -0.8.

If  `type` is equal to `"top1"`, `"top2"` or
`"mean"`, then `args` has to contain a numeric vector of length 1 that
gives the number of top ranks included in the returned adjacency matrix.
In this case
values that are 0 for the models `lasso`, `randomForest` and `bayes` are
set to `NaN`; values from correlation (Pearson and Spearman, including
for partial correlation) and `clr` and `aracne` are
taken as they are.

For `type = "top1"`, the best (i.e. lowest) rank in `am` is taken.
For `type = "top2"`, the second best (i.e. second lowest) rank in
`am` is taken.
For `type = "mean"`, the average rank in `am` is taken.
Subsequently the first `n` unique ranks are returned.
}
\examples{
data("x_test", package = "MetNet")
x <- x_test[1:10, 3:ncol(x_test)]
x <- as.matrix(x)
model <- c("pearson", "spearman")
args <- list()
am_stat <- statistical(x, model = model)

## type = "threshold"
args <- list(filter = "pearson_coef > 0.95 & spearman_coef > 0.95")
threshold(am = am_stat, type = "threshold", args = args)

## type = "top1"
args <- list(n = 10)
threshold(am = am_stat, type = "top1", args = args)

## type = "top2"
threshold(am = am_stat, type = "top2", args = args)

## type = "mean"
threshold(am = am_stat, type = "mean", args = args)

}
\author{
Thomas Naake, \email{thomasnaake@googlemail.com}
}
