% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structural.R
\name{addSpectralSimilarity}
\alias{addSpectralSimilarity}
\title{Adding a spectral similarity matrix to the "structural"
`AdjacencyMatrix`}
\usage{
addSpectralSimilarity(am_structural, ms2_similarity = list())
}
\arguments{
\item{am_structural}{`AdjacencyMatrix` of type "structural" that was created using matching MS1
data of the same data set. The respective spectral similarity matrices will
be added into `am_structural`}

\item{ms2_similarity}{`list` containing spectral similarity adjacency matrices with
matching row-/colnames of the structural `AdjacencyMatrix`. The name of the
list entries should reference to the similarity calcululation method
(e.g. "ndotproduct")}
}
\value{
`AdjacencyMatrix` of type "structural" containing the respective
adjacency matrices in the `assay` slot as specified by `methods`
}
\description{
The function `addSpectralSimilarity` adds adjacency matrices from
spectral similarity into the "structural" `AdjacencyMatrix` object.
One or multiple spectral similarity matrices can be added to the
"structural" `AdjacencyMatrix` object.
}
\details{
The function `addSpectralSimilarity` includes functionality to add
spectral adjacency matrices e.g. that were created by functionality from the
`RforMassSpectrometry` infrastructure.
`addSpectralSimilarity` iterates through a `list` with named spectral
similarity matrices and adds them to the "structural" `AdjacencyMatrix`.
Matching between spectral similarity and "structural" `AdjacencyMatrix` is
performed via rownames/colnames. Thus, it is important that the spectral
similarity matrices have row/colnames matching to the respective MS1 data.
`addSpectralSimilarity` will add the adjacency matrices
and will return the "structural" `AdjacencyMatrix` containing the added
weighted adjacency matrices in the `assays` slot.
}
\examples{
data("x_test", package = "MetNet")
transformation <- rbind(
    c("Monosaccharide (-H2O)", "C6H10O5", "162.0528234315"),
    c("Disaccharide (-H2O)", "C12H20O11", "340.1005614851"),
    c("Trisaccharide (-H2O)", "C18H30O15", "486.1584702945"))
transformation <- data.frame(group = transformation[, 1],
    formula = transformation[, 2],
    mass = as.numeric(transformation[, 3]))
am_struct <- structural(x_test, transformation, var = c("group", "mass"),
    ppm = 10, directed = TRUE)

## load the file containing MS2 similarities
f <- system.file("spectra_matrix/spectra_matrix.RDS", package = "MetNet")
adj_spec <- readRDS(f)

## run the addSpectralSimilarity function
spect_adj <- addSpectralSimilarity(am_structural = am_struct,
   ms2_similarity = list("ndotproduct" = adj_spec))

}
\author{
Liesa Salzer, \email{liesa.salzer@helmholtz-muenchen.de}
}
