% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetScores.R
\name{get_scores_for_LC_MS}
\alias{get_scores_for_LC_MS}
\title{Get scores for metabolite putative IDs by LC-MS .}
\usage{
get_scores_for_LC_MS(filename, type = c("data.frame", "csv", "txt"),
  na = "NA", sep = ";", mode = c("POS", "NEG"), Size = 2000,
  delta = 1, gamma_mass = 10, iterations = 500)
}
\arguments{
\item{filename}{the name of the file which the data are to be read from. Its type should be chosen
in 'type' parameter. Also, it should have columns named exactly 'metid' (IDs for peaks),
'query_m.z' (query mass of peaks), 'exact_m.z' (exact mass of putative IDs),
'kegg_id' (IDs of putative IDs from KEGG Database), 'pubchem_cid' (CIDs of putative IDs
from PubChem Database). Otherwise, this function would not work.}

\item{type}{string indicating the type of the file. It can be a 'data.frame' which is already loaded
into R, or some other specified types like a csv file.}

\item{na}{a character vector of strings which are to be interpreted as NA values.}

\item{sep}{a character value which seperates multiple IDs in kegg_id or pubchem_cid field, if there
are multiple IDs.}

\item{mode}{string indicating the mode of metabolites. It can be positive mode (POS) or negative mode
(NEG).}

\item{Size}{an integer which indicates sample size in Gibbs sampling.}

\item{delta}{a hyper-parameter representing the mean value of mass ratio.}

\item{gamma_mass}{a hyper-parameter representing the accuracy of mass measurement.}

\item{iterations}{ask user to input number of interations,default 500}
}
\value{
A dataframe which contains input data together with a
        column of scores in the end. In the
        score column, if the row contains NA values or does not has a PubChem cid, the score would be
        '-', which stands for missing value. Otherwise, each score would be from 0 to 1.
}
\description{
Get scores for metabolite putative IDs by LC-MS .
}
\examples{
## check if colnames of dataset meet requirement
names(demo1)
## change colnames
colnames(demo1) <- c('query_m.z','name','formula','exact_m.z','pubchem_cid','kegg_id')
## get scores
out <- get_scores_for_LC_MS(demo1, type = 'data.frame', na='-', mode='POS')

}
