% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PreprocessData.R
\name{get_cleaned}
\alias{get_cleaned}
\title{Preprocess input file.}
\usage{
get_cleaned(filename, type = c("data.frame", "csv", "txt"), na, sep)
}
\arguments{
\item{filename}{the name of the file which the data are to be read from. Its type should be chosen
in 'type' parameter. Also, it should have columns named exactly as 'metid' (IDs for peaks),
'query_m.z' (query mass of peaks), 'exact_m.z' (exact mass of putitative IDs),
'kegg_id' (IDs of putitative IDs from KEGG Database), 'pubchem_cid' (CIDs of putitative IDs
from PubChem Database). Otherwise, this function would not work.}

\item{type}{string indicating the type of the file. It can be a 'data.frame' which is already loaded
into R, or some other types like a csv file.}

\item{na}{a character vector of strings which are to be interpreted as NA values.}

\item{sep}{a character value which seperates multiple IDs in kegg_id or pubchem_cid field, if there
are multiple IDs.}
}
\value{
get_cleaned returns a list containing the following components:
       \item{df}{a data frame which is the original input data.}
       \item{clean_data}{a data frame with unuseful observations and features removed.}
       \item{mass}{a data frame with unique query peak, along with query mass.}
       \item{ID}{a data frame with unique putitative IDs, along with PubChem ID, KEGG ID, exact mass.}
       \item{index_na}{a vector of row indexes which contains NA values.}
}
\description{
Preprocess input file.
}
