% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyApp.R
\name{replayPlotOrder}
\alias{replayPlotOrder}
\title{Wrapper for \code{replayPlot}}
\usage{
replayPlotOrder(orderMatch = "mz", onCircle = FALSE, plot_l, ind)
}
\arguments{
\item{orderMatch}{\code{character}, either \code{"mz"}, 
\code{"retentionTime"} or \code{"clustering"}}

\item{onCircle}{\code{logical}, are coordinates on circle. If \code{FALSE} 
and no features are selected (\code{length(ind) == 0}), then filled plots 
are replayed, otherwise highlighted plots are replayed.}

\item{plot_l}{\code{list} with plots}

\item{ind}{\code{numeric}, indices of clicked features}
}
\value{
\code{replayedplot}
}
\description{
\code{replayPlotOrder} will call \code{replayPlot} from \code{grDevices} with
a \code{recordedplot} object based on \code{orderMatch}.
}
\details{
Helper function for \code{shinyCircos}.
}
\examples{
type_match <- c("a_1", "a_2", "a_3", "b_1", "b_2", "b_3", "c_1", "c_2")
plotCircos(type_match, NULL, initialize = TRUE, featureNames = TRUE,
    groupSector = TRUE, groupName = FALSE, links = FALSE,
    highlight = TRUE)
p <- recordPlot()
plot.new()
plot_l <- list(highlightMz = p)
MetCirc:::replayPlotOrder(orderMatch = "mz", onCircle = TRUE,
    plot_l = plot_l, ind = NULL)

}
\author{
Thomas Naake, \email{thomasnaake@googlemail.com}
}
