% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shinyApp.R
\name{replayPlotAdd}
\alias{replayPlotAdd}
\title{Plot plotCircos or highlight}
\usage{
replayPlotAdd(
  orderMatch = "mz",
  onCircle = FALSE,
  linkDf,
  mz_match,
  rt_match,
  clust_match,
  ind,
  indMz,
  indRT,
  indCluster
)
}
\arguments{
\item{orderMatch}{\code{character(1)}, either \code{"mz"}, 
\code{"retentionTime"}, or \code{"clustering"}}

\item{onCircle}{\code{logical}, are coordinates on circle. If \code{FALSE} 
and no features are selected (\code{length(ind) == 0}), then filled plots are 
replayed, otherwise highlighted plots are replayed.}

\item{linkDf}{\code{data.frame} that contains information of linked 
features for given thresholds}

\item{mz_match}{\code{character}, ordered vector according to m/z}

\item{rt_match}{\code{character}, ordered vector according to retention time}

\item{clust_match}{\code{character}, ordered vector according to clustering}

\item{ind}{\code{numeric}, indices of clicked features}

\item{indMz}{\code{numeric}, indices of clicked features for \code{"mz"}
ordering}

\item{indRT}{\code{numeric}, indices of clicked features for 
\code{"retentionTime"} ordering}

\item{indCluster}{\code{numeric}, indices of clicked features for 
\code{"clustering"} ordering}
}
\value{
Depending on \code{onCircle} and \code{indMz} either returns 
\code{plotCircos} or \code{highlight}
}
\description{
\code{replayPlotAdd} plots additional plots on a plot, either
plots \code{plotCircos} or \code{highlight}.
}
\details{
Helper function for \code{shinyCircos}.
}
\examples{
data("spectra", package = "MetCirc")
similarityMat <- Spectra::compareSpectra(sps_tissue[1:10],
    FUN = MsCoreUtils::ndotproduct, ppm = 10, m = 0.5, n = 2)
rownames(similarityMat) <- colnames(similarityMat) <- sps_tissue$name[1:10]
  
## order according to m/z 
mz_match <- MetCirc:::typeMatch_link0(similarityMatrix = similarityMat, 
    sps = sps_tissue, type = "mz", 
    condition = c("SPL", "LIM", "ANT", "STY"))
linkDf <- mz_match[["link0df"]]
mz_match <- mz_match[["type_match"]]

## order according to retention time 
rt_match <- MetCirc:::typeMatch_link0(similarityMatrix = similarityMat, 
    sps = sps_tissue, type = "retentionTime", 
    condition = c("SPL", "LIM", "ANT", "STY"))
rt_match <- rt_match[["type_match"]]

## order according to clustering
clust_match <- MetCirc:::typeMatch_link0(similarityMatrix = similarityMat, 
    sps = sps_tissue, type = "clustering", 
    condition = c("SPL", "LIM", "ANT", "STY"))
clust_match <- clust_match[["type_match"]]
circos.initialize(mz_match,##, levels  =  mz_match),
    xlim = matrix(rep(c(0,1), length(mz_match)), ncol = 2, byrow = TRUE))
#circos.trackPlotRegion(factor(mz_match, levels = mz_match), ylim = c(0,1))  
MetCirc:::replayPlotAdd(orderMatch = "mz", onCircle = FALSE, linkDf = linkDf, 
    mz_match = mz_match, rt_match = rt_match, clust_match = clust_match, 
    ind = 1, indMz = NULL, indRT = NULL, indCluster = NULL)

}
\author{
Thomas Naake, \email{thomasnaake@googlemail.com}
}
