% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/similarity.R
\name{orderSimilarityMatrix}
\alias{orderSimilarityMatrix}
\title{Order columns and rows of a similarity matrix according to 
m/z, retention time and clustering}
\usage{
orderSimilarityMatrix(
  similarityMatrix,
  sps,
  type = c("retentionTime", "mz", "clustering"),
  group = FALSE
)
}
\arguments{
\item{similarityMatrix}{\code{matrix}, \code{similarityMatrix} contains 
pair-wise similarity coefficients which give information about the similarity 
between precursors}

\item{sps}{\code{Spectra} object containing spectra that are compared
in \code{similarityMatrix}}

\item{type}{\code{character(1)}, one of \code{"retentionTime"}, \code{"mz"}, or 
\code{"clustering"}}

\item{group}{\code{logical(1)}, if \code{TRUE} \code{group} separated by 
\code{"_"} will be cleaved  from \code{rownames}/\code{colnames} of 
\code{similarityMatrix} and matched against names of \code{sps}
(\code{sps$name}), if \code{FALSE} \code{rownames}/\code{colnames} of 
\code{similarityMatrix} are taken as are and matched against names of 
\code{sps} (\code{sps$name})}
}
\value{
\code{matrix}, \code{orderSimilarityMatrix} returns a similarity 
matrix with ordered \code{rownames} according to the \code{character} vector 
\code{type}
}
\description{
Internal function for shiny application. May also be used 
outside of shiny to reconstruct figures.
}
\details{
\code{orderSimilarityMatrix} takes a similarity matrix,
\code{Spectra} object (\code{sps}, containing information on m/z and 
retention time), and a \code{character} vector as arguments. It will then 
reorder rows and columns of the \code{similarityMatrix} object such, 
that it orders rows and columns of \code{similarityMatrix} according to 
m/z, retention time or clustering in each group. 

\code{orderSimilarityMatrix} is employed in the \code{shinyCircos} 
function to create \code{similarityMatrix} objects which will allow to switch
between different types of ordering in between groups (sectors) in the 
circos plot. It may be used as well externally, to reproduce plots outside
of the reactive environment (see vignette for a workflow).
}
\examples{
data("spectra", package = "MetCirc")
similarityMat <- Spectra::compareSpectra(sps_tissue[1:10], 
    FUN = MsCoreUtils::ndotproduct, ppm = 10)
rownames(similarityMat) <- colnames(similarityMat) <- sps_tissue$name[1:10]

## order according to retention time 
orderSimilarityMatrix(similarityMatrix = similarityMat, 
    sps = sps_tissue, type = "retentionTime", group = FALSE)
    
}
\author{
Thomas Naake, \email{thomasnaake@googlemail.com}
}
