% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMutSigProfile.R
\name{plotMutSigProfile}
\alias{plotMutSigProfile}
\title{plotMutSigProfile}
\usage{
plotMutSigProfile(
  sig_input,
  patient.id = NULL,
  mode = NULL,
  contribution.type = "relative",
  use.tumorSampleLabel = FALSE
)
}
\arguments{
\item{sig_input}{Result generated by function \code{\link{fitSignatures}} or \code{\link{triMatrix}}.}

\item{patient.id}{Select the specific patients. Default NULL, all patients are included.}

\item{mode}{Type of mutation spectrum. Default NULL. Options:'Original','Reconstructed' or 'Difference'}

\item{contribution.type}{Type of Signature contribution. Default 'realative'. Options:'realative' or 'absolute'.}

\item{use.tumorSampleLabel}{Logical (Default: FALSE). Rename the 'Tumor_Sample_Barcode' by 'Tumor_Sample_Label'.}
}
\value{
Mutational signature profile of patients
}
\description{
plotMutSigProfile
}
\examples{
## input from fitSignatures
maf.File <- system.file("extdata/", "CRC_HZ.maf", package = "MesKit")
clin.File <- system.file("extdata/", "CRC_HZ.clin.txt", package = "MesKit")
ccf.File <- system.file("extdata/", "CRC_HZ.ccf.tsv", package = "MesKit")
maf <- readMaf(mafFile=maf.File, clinicalFile = clin.File, ccfFile=ccf.File, refBuild="hg19")
phyloTree <- getPhyloTree(maf, patient.id = 'V402')

## Load a reference genome.
library(BSgenome.Hsapiens.UCSC.hg19)

tri_matrix <- triMatrix(phyloTree)
fit_out <- fitSignatures(tri_matrix)
plotMutSigProfile(fit_out)
## input from treeMatrix
plotMutSigProfile(tri_matrix)

}
