% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMutProfile.R
\name{plotMutProfile}
\alias{plotMutProfile}
\title{plotMutProfile}
\usage{
plotMutProfile(
  maf,
  patient.id = NULL,
  class = "SP",
  classByTumor = FALSE,
  topGenesCount = 10,
  geneList = NULL,
  sample.text.size = 11,
  gene.text.size = 11,
  legend.text.size = 11,
  legend.title.size = 11,
  bgCol = "#f0f0f0",
  patientsCol = NULL,
  removeEmptyCols = TRUE,
  removeEmptyRows = TRUE,
  showColnames = TRUE,
  sampleOrder = NULL,
  use.tumorSampleLabel = FALSE,
  ...
)
}
\arguments{
\item{maf}{Maf or MafList object generated by \code{\link{readMaf}} function.}

\item{patient.id}{Select or reorder the patients. Default NULL, all patients are included.
Classify SSNVs/Indels into Shared/P-shared/Private, Clonal/Subclonl
or Shared-Clonal/P-shared-Clonal/Private-Clonal/Shared-Subclonal/P-shared-SubClonal/Private-SubClonal}

\item{class}{The class which would be represented. Default "SP" (Shared pattern: Public/Shared/Private),
other options: "CS" (Clonal status: Clonal/Subclonl) and "SPCS".}

\item{classByTumor}{Logical (Default: FALSE). Define shared pattern of mutations based on tumor types (TRUE) or samples (FALSE)}

\item{topGenesCount}{The number of genes print, Default 10.}

\item{geneList}{A list of genes to restrict the analysis. Default NULL.}

\item{sample.text.size}{Fontsize of sample name. Default 11.}

\item{gene.text.size}{Fontsize of gene text. Default 11.}

\item{legend.text.size}{Fontsize of legend text. Default 11.}

\item{legend.title.size}{Fontsize of legend title. Default 11.}

\item{bgCol}{Background grid color. Default "#f0f0f0".}

\item{patientsCol}{A list containing customized colors for distinct patients. Default NULL.}

\item{removeEmptyCols}{Logical (Default: TRUE). Whether remove the samples without alterations.}

\item{removeEmptyRows}{Logical (Default: TRUE). Whether remove the genes without alterations.}

\item{showColnames}{Logical (Default: TRUE). Show sample names of columns.}

\item{sampleOrder}{A named list which contains the sample order used in plotting the final profile. Default NULL.}

\item{use.tumorSampleLabel}{Logical (Default: FALSE). Rename the 'Tumor_Sample_Barcode' with 'Tumor_Sample_Label'.}

\item{...}{Other options passed to \code{\link{subMaf}}}
}
\value{
Mutational profile
}
\description{
plotMutProfile
}
\examples{
maf.File <- system.file("extdata/", "CRC_HZ.maf", package = "MesKit")
clin.File <- system.file("extdata/", "CRC_HZ.clin.txt", package = "MesKit")
ccf.File <- system.file("extdata/", "CRC_HZ.ccf.tsv", package = "MesKit")
maf <- readMaf(mafFile=maf.File, clinicalFile = clin.File, ccfFile=ccf.File, refBuild="hg19")
plotMutProfile(maf, class = "SP")
}
