% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{getMutBranches}
\alias{getMutBranches}
\alias{getMutBranches,phyloTree-method}
\title{getMutBranches}
\usage{
getMutBranches(object)

\S4method{getMutBranches}{phyloTree}(object)
}
\arguments{
\item{object}{An object of phyloTree}
}
\value{
Branches mutation of phyloTree
}
\description{
getMutBranches
}
\examples{
maf.File <- system.file("extdata/", "CRC_HZ.maf", package = "MesKit")
clin.File <- system.file("extdata/", "CRC_HZ.clin.txt", package = "MesKit")
ccf.File <- system.file("extdata/", "CRC_HZ.ccf.tsv", package = "MesKit")
maf <- readMaf(mafFile=maf.File, clinicalFile = clin.File, ccfFile=ccf.File, refBuild="hg19")
phyloTree <- getPhyloTree(maf)
getMutBranches(phyloTree$V402)
}
