% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{getBranchType}
\alias{getBranchType}
\alias{getBranchType,phyloTree-method}
\title{getBranchType}
\usage{
getBranchType(object)

\S4method{getBranchType}{phyloTree}(object)
}
\arguments{
\item{object}{An object of phyloTree}
}
\value{
Branch type of phyloTree
}
\description{
getBranchType
}
\examples{
maf.File <- system.file("extdata/", "CRC_HZ.maf", package = "MesKit")
clin.File <- system.file("extdata/", "CRC_HZ.clin.txt", package = "MesKit")
ccf.File <- system.file("extdata/", "CRC_HZ.ccf.tsv", package = "MesKit")
maf <- readMaf(mafFile=maf.File, clinicalFile = clin.File, ccfFile=ccf.File, refBuild="hg19")
phyloTree <- getPhyloTree(maf)
getBranchType(phyloTree$V402)
}
