#'  triMatrix 
#' @description Calculate the frequency of 96 trinucleotide mutation based on somatic SNVs. 
#' 
#' @param phyloTree phyloTree or phyloTreeList object generated by \code{\link{getPhyloTree}} function.
#' @param patient.id Select the specific patients. Default NULL, all patients are included
#' @param level Calculate the frequency of 96 trinucleotide mutatio on different levels. 
#' 1: patient-level, 2: tumor-level, 3: sample-level, 4: branch-level, 5: shared pattern (public/shared/private) of each tumor. 
#' 6: trunk/branch-level. Default 2.
#' @return The frequency of 96 trinucleotide mutation.
#' 
#' @importFrom Biostrings getSeq
#' @importFrom S4Vectors Rle
#' @examples
#' maf.File <- system.file("extdata/", "CRC_HZ.maf", package = "MesKit")
#' clin.File <- system.file("extdata/", "CRC_HZ.clin.txt", package = "MesKit")
#' ccf.File <- system.file("extdata/", "CRC_HZ.ccf.tsv", package = "MesKit")
#' maf <- readMaf(mafFile=maf.File, clinicalFile = clin.File, ccfFile=ccf.File, refBuild="hg19")
#' 
#' ## Load a reference genome.
#' library(BSgenome.Hsapiens.UCSC.hg19)
#' 
#' phyloTree <- getPhyloTree(maf, patient.id = 'V402')
#' triMatrix(phyloTree)
#' @export  triMatrix


triMatrix <- function(phyloTree,
                      patient.id = NULL,
                      level = 2){
  ## check input data
  phyloTree_input <- subPhyloTree(phyloTree, patient.id = patient.id)
  result <- subTriMatrix(phyloTree_input, level = level)
  if(length(result) == 0){
    return(NA)
  }else{
    return(result)
  }
  
}