% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_plot.R
\name{plot_melissa_profiles}
\alias{plot_melissa_profiles}
\title{Plot predictive methylaation profiles}
\usage{
plot_melissa_profiles(
  melissa_obj,
  region = 1,
  title = "Melissa profiles",
  x_axis = "genomic region",
  y_axis = "met level",
  x_labels = c("Upstream", "", "Centre", "", "Downstream"),
  ...
)
}
\arguments{
\item{melissa_obj}{Clustered cell subtypes using Melissa inference functions.}

\item{region}{Genomic region number.}

\item{title}{Plot title}

\item{x_axis}{x axis label}

\item{y_axis}{x axis label}

\item{x_labels}{x axis ticks labels}

\item{...}{Additional parameters}
}
\value{
A ggplot2 object.
}
\description{
This function plots the predictive distribution of the
  methylation profiles inferred using the Melissa model. Each colour
  corresponds to a different cluster.
}
\examples{
# Extract synthetic data
dt <- melissa_synth_dt

# Create basis object from BPRMeth package
basis_obj <- BPRMeth::create_rbf_object(M = 3)

# Run Melissa
melissa_obj <- melissa(X = dt$met, K = 2, basis = basis_obj, vb_max_iter = 10,
   vb_init_nstart = 1, is_parallel = FALSE, is_verbose = FALSE)

gg <- plot_melissa_profiles(melissa_obj, region = 10)

}
\seealso{
\code{\link{create_melissa_data_obj}}, \code{\link{melissa}},
\code{\link{filter_regions}}, \code{\link{eval_imputation_performance}},
\code{\link{eval_cluster_performance}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
