% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/melissa_vb.R
\name{melissa}
\alias{melissa}
\alias{melissa_cluster,}
\alias{melissa_impute,}
\alias{melissa_vb}
\title{Cluster and impute single cell methylomes using VB}
\usage{
melissa(
  X,
  K = 3,
  basis = NULL,
  delta_0 = NULL,
  w = NULL,
  alpha_0 = 0.5,
  beta_0 = NULL,
  vb_max_iter = 300,
  epsilon_conv = 1e-05,
  is_kmeans = TRUE,
  vb_init_nstart = 10,
  vb_init_max_iter = 20,
  is_parallel = FALSE,
  no_cores = 3,
  is_verbose = TRUE
)
}
\arguments{
\item{X}{The input data, which has to be a \link[base]{list} of elements of
length N, where N are the total number of cells. Each element in the list
contains another list of length M, where M is the total number of genomic
regions, e.g. promoters. Each element in the inner list is an \code{I X 2}
matrix, where I are the total number of observations. The first column
contains the input observations x (i.e. CpG locations) and the 2nd columns
contains the corresponding methylation level.}

\item{K}{Integer denoting the total number of clusters K.}

\item{basis}{A 'basis' object. E.g. see create_basis function from BPRMeth
package. If NULL, will an RBF object with 3 basis functions will be
created.}

\item{delta_0}{Parameter vector of the Dirichlet prior on the mixing
proportions pi.}

\item{w}{Optional, an Mx(D)xK array of the initial parameters, where first
dimension are the genomic regions M, 2nd the number of covariates D (i.e.
basis functions), and 3rd are the clusters K. If NULL, will be assigned
with default values.}

\item{alpha_0}{Hyperparameter: shape parameter for Gamma distribution. A
Gamma distribution is used as prior for the precision parameter tau.}

\item{beta_0}{Hyperparameter: rate parameter for Gamma distribution. A Gamma
distribution is used as prior for the precision parameter tau.}

\item{vb_max_iter}{Integer denoting the maximum number of VB iterations.}

\item{epsilon_conv}{Numeric denoting the convergence threshold for VB.}

\item{is_kmeans}{Logical, use Kmeans for initialization of model parameters.}

\item{vb_init_nstart}{Number of VB random starts for finding better
initialization.}

\item{vb_init_max_iter}{Maximum number of mini-VB iterations.}

\item{is_parallel}{Logical, indicating if code should be run in parallel.}

\item{no_cores}{Number of cores to be used, default is max_no_cores - 1.}

\item{is_verbose}{Logical, print results during VB iterations.}
}
\value{
An object of class \code{melissa} with the following elements:
  \itemize{ \item{ \code{W}: An (M+1) X K matrix with the optimized parameter
  values for each cluster, M are the number of basis functions. Each column
  of the matrix corresponds a different cluster k.} \item{ \code{W_Sigma}: A
  list with the covariance matrices of the posterior parmateter W for each
  cluster k.} \item{ \code{r_nk}: An (N X K) responsibility matrix of each
  observations being explained by a specific cluster. } \item{ \code{delta}:
  Optimized Dirichlet paramter for the mixing proportions. } \item{
  \code{alpha}: Optimized shape parameter of Gamma distribution. } \item{
  \code{beta}: Optimized rate paramter of the Gamma distribution } \item{
  \code{basis}: The basis object. } \item{\code{lb}: The lower bound vector.}
  \item{\code{labels}: Cluster assignment labels.} \item{ \code{pi_k}:
  Expected value of mixing proportions.} }
}
\description{
\code{melissa} clusters and imputes single cells based on their
  methylome landscape on specific genomic regions, e.g. promoters, using the
  Variational Bayes (VB) EM-like algorithm.
}
\section{Details}{
 The modelling and mathematical details for clustering
  profiles using mean-field variational inference are explained here:
  \url{http://rpubs.com/cakapourani/} . More specifically: \itemize{\item{For
  Binomial/Bernoulli observation model check:
  \url{http://rpubs.com/cakapourani/vb-mixture-bpr}} \item{For Gaussian
  observation model check: \url{http://rpubs.com/cakapourani/vb-mixture-lr}}}
}

\examples{
# Example of running Melissa on synthetic data

# Create RBF basis object with 4 RBFs
basis_obj <- BPRMeth::create_rbf_object(M = 4)

set.seed(15)
# Run Melissa
melissa_obj <- melissa(X = melissa_synth_dt$met, K = 2, basis = basis_obj,
   vb_max_iter = 10, vb_init_nstart = 1, vb_init_max_iter = 5,
   is_parallel = FALSE, is_verbose = FALSE)

# Extract mixing proportions
print(melissa_obj$pi_k)

}
\seealso{
\code{\link{create_melissa_data_obj}},
  \code{\link{partition_dataset}}, \code{\link{plot_melissa_profiles}},
  \code{\link{impute_test_met}}, \code{\link{impute_met_files}},
  \code{\link{filter_regions}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
