% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/melissa_gibbs.R
\name{melissa_gibbs}
\alias{melissa_gibbs}
\title{Gibbs sampling algorithm for Melissa model}
\usage{
melissa_gibbs(
  X,
  K = 2,
  pi_k = rep(1/K, K),
  w = NULL,
  basis = NULL,
  w_0_mean = NULL,
  w_0_cov = NULL,
  dir_a = rep(1, K),
  lambda = 1/2,
  gibbs_nsim = 1000,
  gibbs_burn_in = 200,
  inner_gibbs = FALSE,
  gibbs_inner_nsim = 50,
  is_parallel = TRUE,
  no_cores = NULL,
  is_verbose = FALSE
)
}
\arguments{
\item{X}{A list of length I, where I are the total number of cells. Each
element of the list contains another list of length N, where N is the total
number of genomic regions. Each element of the inner list is an L x 2
matrix of observations, where 1st column contains the locations and the 2nd
column contains the methylation level of the corresponding CpGs.}

\item{K}{Integer denoting the number of clusters K.}

\item{pi_k}{Vector of length K, denoting the mixing proportions.}

\item{w}{A N x M x K array, where each column contains the basis function
coefficients for the corresponding cluster.}

\item{basis}{A 'basis' object. E.g. see create_rbf_object from BPRMeth
package}

\item{w_0_mean}{The prior mean hyperparameter for w}

\item{w_0_cov}{The prior covariance hyperparameter for w}

\item{dir_a}{The Dirichlet concentration parameter, prior over pi_k}

\item{lambda}{The complexity penalty coefficient for penalized regression.}

\item{gibbs_nsim}{Argument giving the number of simulations of the Gibbs
sampler.}

\item{gibbs_burn_in}{Argument giving the burn in period of the Gibbs sampler.}

\item{inner_gibbs}{Logical, indicating if we should perform Gibbs sampling to
sample from the augmented BPR model.}

\item{gibbs_inner_nsim}{Number of inner Gibbs simulations.}

\item{is_parallel}{Logical, indicating if code should be run in parallel.}

\item{no_cores}{Number of cores to be used, default is max_no_cores - 1.}

\item{is_verbose}{Logical, print results during EM iterations}
}
\value{
An object of class \code{melissa_gibbs}.
}
\description{
\code{melissa_gibbs} implements the Gibbs sampling algorithm
  for performing clustering of single cells based on their DNA methylation
  profiles, where the observation model is the Bernoulli distributed Probit
  Regression likelihood. NOTE: that Gibbs sampling is really slow and we
  recommend using the VB implementation: \code{\link{melissa}}.
}
\examples{
# Example of running Melissa Gibbs on synthetic data

# Create RBF basis object with 4 RBFs
basis_obj <- BPRMeth::create_rbf_object(M = 4)

set.seed(15)
# Run Melissa Gibbs
melissa_obj <- melissa_gibbs(X = melissa_synth_dt$met, K = 2, basis = basis_obj,
   gibbs_nsim = 10, gibbs_burn_in = 5, is_parallel = FALSE, is_verbose = FALSE)

# Extract mixing proportions
print(melissa_obj$pi_k)

}
\seealso{
\code{\link{melissa}}, \code{\link{create_melissa_data_obj}},
  \code{\link{partition_dataset}}, \code{\link{filter_regions}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
