% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{impute_met_files}
\alias{impute_met_files}
\title{Impute/predict methylation files}
\usage{
impute_met_files(
  met_dir,
  outdir = NULL,
  obj,
  anno_region,
  basis = NULL,
  is_predictive = TRUE,
  no_cores = NULL
)
}
\arguments{
\item{met_dir}{Directory of methylation files, each file corresponds to a
single cell. It should contain three columns <chr> <pos> <met_state>
(similar to the input required by \code{\link{create_melissa_data_obj}}),
where \code{met_state} can be any value that denotes missing CpG
information, e.g. -1. Note that files can contain also CpGs for which we
have coverage information, and we can check the predictions made by
Melissa, hence the value can also be 0 (unmet) or (1) met. Predictions made
by Melissa, will not change the <met_state> column. Melissa will just add
an additional column named <predicted>.}

\item{outdir}{Directory to store the output files for each cell with exactly
the same name. If NULL, then a directory called `imputed` inside `met_dir`
will be created by default.}

\item{obj}{Output of Melissa inference object.}

\item{anno_region}{Annotation region object. This will be the outpuf of
\code{\link{create_melissa_data_obj}} function, e..g
melissa_data$anno_region. This is required to select those regions that
were used to train Melissa.}

\item{basis}{Basis object, if NULL we perform imputation using Melissa,
otherwise using BPRMeth (then \code{obj} should be BPRMeth output).}

\item{is_predictive}{Logical, use predictive distribution for imputation, or
choose the cluster label with the highest responsibility.}

\item{no_cores}{Number of cores to be used for parallel processing of data.}
}
\value{
A new directory \code{outdir} containing files (cells) with predicted
  / imputed methylation states per CpG location.
}
\description{
Make predictions of missing methylation states, i.e. perfrom
  imputation using Melissa. Each file in the directory will be used as input
  and a new file will be created in \code{outdir} with an additional column
  containing the predicted met state (value between 0 and 1). Note that
  predictions will be made only on \code{annotation regions} that were used
  for training Melissa. Check \code{\link{impute_test_met}}, if you want to
  make predictions only on test data.
}
\examples{
\dontrun{
# Met directory
met_dir <- "name_of_met_dir"
# Annotation file name
anno_file <- "name_of_anno_file"
# Create data object
melissa_data <- create_melissa_data_obj(met_dir, anno_file)
# Run Melissa
melissa_obj <- melissa(X = melissa_data$met, K = 2)
# Annotation object
anno_region <- melissa_data$anno_region

# Peform imputation
impute_met_dir <- "name_of_met_dir_for_imputing_cells"
out <- impute_met_files(met_dir = impute_met_dir, obj = melissa_obj,
                        anno_region = anno_region)
}


}
\seealso{
\code{\link{create_melissa_data_obj}}, \code{\link{melissa}},
  \code{\link{filter_regions}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
