% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{eval_imputation_performance}
\alias{eval_imputation_performance}
\title{Evaluate imputation performance}
\usage{
eval_imputation_performance(obj, imputation_obj)
}
\arguments{
\item{obj}{Output of Melissa inference object.}

\item{imputation_obj}{List containing two vectors of equal length,
corresponding to true methylation states and predicted/imputed methylation
states.}
}
\value{
The `melissa` object, with an additional slot named `imputation`,
  containing the AUC, F-measure, True Positive Rate (TPR) and False Positive
  Rate (FPR), and Precision Recall (PR) curves.
}
\description{
\code{eval_imputation_performance} is a wrapper function for
  computing imputation/clustering performance in terms of different metrics,
  such as AUC and precision recall curves.
}
\examples{
# First take a subset of cells to efficiency
# Extract synthetic data
dt <- melissa_synth_dt

# Partition to train and test set
dt <- partition_dataset(dt)

# Create basis object from BPRMeth package
basis_obj <- BPRMeth::create_rbf_object(M = 3)

# Run Melissa
melissa_obj <- melissa(X = dt$met, K = 2, basis = basis_obj, vb_max_iter = 10,
  vb_init_nstart = 1, is_parallel = FALSE, is_verbose = FALSE)

imputation_obj <- impute_test_met(obj = melissa_obj, test = dt$met_test)

melissa_obj <- eval_imputation_performance(obj = melissa_obj,
                                           imputation_obj = imputation_obj)

cat("AUC: ", melissa_obj$imputation$auc)

}
\seealso{
\code{\link{create_melissa_data_obj}}, \code{\link{melissa}},
  \code{\link{impute_test_met}}, \code{\link{filter_regions}},
  \code{\link{eval_imputation_performance}},
  \code{\link{eval_cluster_performance}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
