% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{eval_cluster_performance}
\alias{eval_cluster_performance}
\title{Evaluate clustering performance}
\usage{
eval_cluster_performance(obj, C_true)
}
\arguments{
\item{obj}{Output of Melissa inference object.}

\item{C_true}{True cluster assignemnts.}
}
\value{
The `melissa` object, with an additional slot named `clustering`,
  containing the ARI and clustering assignment error performance.
}
\description{
\code{eval_cluster_performance} is a wrapper function for
  computing clustering performance in terms of ARI and clustering assignment
  error.
}
\examples{
## Extract synthetic data
dt <- melissa_synth_dt

# Partition to train and test set
dt <- partition_dataset(dt)

# Create basis object from BPRMeth package
basis_obj <- BPRMeth::create_rbf_object(M = 3)

# Run Melissa
melissa_obj <- melissa(X = dt$met, K = 2, basis = basis_obj, vb_max_iter = 10,
  vb_init_nstart = 1, is_parallel = FALSE, is_verbose = FALSE)

# Compute cluster performance
melissa_obj <- eval_cluster_performance(melissa_obj, dt$opts$C_true)

cat("ARI: ", melissa_obj$clustering$ari)

}
\seealso{
\code{\link{create_melissa_data_obj}}, \code{\link{melissa}},
  \code{\link{filter_regions}}, \code{\link{eval_imputation_performance}},
  \code{\link{eval_cluster_performance}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
