% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_data.R
\name{create_melissa_data_obj}
\alias{create_melissa_data_obj}
\title{Create methylation regions for all cells}
\usage{
create_melissa_data_obj(
  met_dir,
  anno_file,
  chrom_size_file = NULL,
  chr_discarded = NULL,
  is_centre = FALSE,
  is_window = TRUE,
  upstream = -5000,
  downstream = 5000,
  cov = 5,
  sd_thresh = -1,
  no_cores = NULL
)
}
\arguments{
\item{met_dir}{Directory of (binarised) methylation files, each file
corresponds to a single cell.}

\item{anno_file}{The annotation file with `tab` delimited format:
"chromosome", "start", "end", "strand", "id", "name" (optional). Read the
`BPRMeth` documentation for more details.}

\item{chrom_size_file}{Optional file name to read genome chromosome sizes.}

\item{chr_discarded}{Optional vector with chromosomes to be discarded.}

\item{is_centre}{Logical, whether 'start' and 'end' locations are
pre-centred. If TRUE, the mean of the locations will be chosen as centre.
If FALSE, the 'start' will be chosen as the center; e.g. for genes the
'start' denotes the TSS and we use this as centre to obtain K-bp upstream
and downstream of TSS.}

\item{is_window}{Whether to consider a predefined window region around
centre. If TRUE, then 'upstream' and 'downstream' parameters are used,
otherwise we consider the whole region from start to end location.}

\item{upstream}{Integer defining the length of bp upstream of 'centre' for
creating the genomic region. If is_window = FALSE, this parameter is
ignored.}

\item{downstream}{Integer defining the length of bp downstream of 'centre'
for creating the genomic region. If is_window = FALSE, this parameter is
ignored.}

\item{cov}{Integer defining the minimum coverage of CpGs that each region
must contain.}

\item{sd_thresh}{Optional numeric defining the minimum standard deviation of
the methylation change in a region. This is used to filter regions with no
methylation variability.}

\item{no_cores}{Number of cores to be used for parallel processing of data.}
}
\value{
A \code{melissa_data_obj} object, with the following elements:
  \itemize{ \item{ \code{met}: A list of elements of length N, where N are
  the total number of cells. Each element in the list contains another list
  of length M, where M is the total number of genomic regions, e.g.
  promoters. Each element in the inner list is an \code{I X 2} matrix, where
  I are the total number of observations. The first column contains the input
  observations x (i.e. CpG locations) and the 2nd column contains the
  corresponding methylation level.} \item {\code{anno_region}: The annotation
  object.} \item {\code{opts}: A list with the parameters that were used for
  creating the object. } }
}
\description{
Wrapper function for creating methylation regions for all cells,
  which is the input object for Melissa prior to filtering.
}
\examples{
\dontrun{
# Met directory
met_dir <- "name_of_met_dir"
# Annotation file name
anno_file <- "name_of_anno_file"

obj <- create_melissa_data_obj(met_dir, anno_file)

# Extract annotation regions
met <- obj$met

# Extract annotation regions
anno <- obj$anno_region
}

}
\seealso{
\code{\link{binarise_files}}, \code{\link{melissa}},
  \code{\link{filter_regions}}
}
\author{
C.A.Kapourani \email{C.A.Kapourani@ed.ac.uk}
}
