#' @title \code{Melissa}: Bayesian clustering and imputation of single cell
#'   methylomes
#' @description Bayesian clustering and imputation of single cell methylomes
#' @docType package
#' @name Melissa
#'
#' @return Melissa main package documentation.
#'
#' @seealso \code{\link{melissa}}, \code{\link{create_melissa_data_obj}},
#'   \code{\link{partition_dataset}}, \code{\link{plot_melissa_profiles}},
#'   \code{\link{filter_regions}}
#'
#' @author C.A.Kapourani \email{kapouranis.andreas@@gmail.com}
#'
#' @rawNamespace importFrom(magrittr,"%>%")
#' @rawNamespace importFrom(data.table,":=")
#' @rawNamespace importFrom(foreach, "%dopar%")
#' @import GenomicRanges ggplot2 BiocStyle
#' @importFrom stats pnorm dbinom dnorm
#' @importFrom matrixcalc matrix.trace
#' @importFrom cowplot plot_grid
#'
.datatable.aware <- TRUE
NULL
#> NULL


.onLoad <- function(libname = find.package("Melissa"), pkgname = "Melissa"){
  # CRAN Note avoidance
  if (getRversion() >= "2.15.1")
    utils::globalVariables(
      # sample file names from taxstats
      c(# we use the magrittr pipe
        "."
      )
    )
  invisible()
}


#' @title Synthetic ENCODE single cell methylation data
#'
#' @description Small synthetic ENCODE data generated by inferring methylation
#'   profiles from bulk ENCODE data, and subsequently generating single cells.
#'   It consists of N = 200 cells and M = 100 genomic regions. The data are in
#'   the required format for directly running Melissa and are used as a case
#'   study for the vignette.
#'
#' @format A list object containing methylation regions, annotation data and the
#'   options used for creating the data. This in general would be the output of
#'   the \code{\link{create_melissa_data_obj}} function. It has the following
#'   three objects: \itemize{ \item{ \code{met}: A list containing the
#'   methylation data, each element of the list is a different cell.} \item{
#'   \code{anno_region}: Corresponding annotation data for each genomic region.}
#'   \item{ \code{opts}: Parameters/options used to generate the data.} }
#'
#' @return Synthetic ENCODE methylation data
#'
#' @seealso \code{\link{create_melissa_data_obj}}
"melissa_encode_dt"



#' @title Synthetic single cell methylation data
#'
#' @description Small synthetic data for quick analysis. It consists of N = 50
#'   cells and M = 50 genomic regions.
#'
#' @format A list object containing methylation regions, annotation data and the
#'   options used for creating the data. This in general would be the output of
#'   the \code{\link{create_melissa_data_obj}} function. It has the following
#'   three objects: \itemize{ \item{ \code{met}: A list containing the
#'   methylation data, each element of the list is a different cell.} \item{
#'   \code{anno_region}: Corresponding annotation data for each genomic region.}
#'   \item{ \code{opts}: Parameters/options used to generate the data.} }
#'
#' @return Synthetic methylation data
#'
#' @seealso \code{\link{create_melissa_data_obj}}
"melissa_synth_dt"
