% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_dimensionreduction.R
\name{plotPCALoadings}
\alias{plotPCALoadings}
\title{Plot for PCA loadings of features}
\usage{
plotPCALoadings(tbl, x_coord, y_coord)
}
\arguments{
\item{tbl}{\code{tbl} as obtained by the function \code{dimensionReduction}}

\item{x_coord}{\code{character}, column name of \code{tbl} that stores x 
coordinates}

\item{y_coord}{\code{character}, column name of \code{tbl} that stores y 
coordinates}
}
\value{
\code{plotly}
}
\description{
The function \code{plotPCALoadings} creates a loadings plot of the features.
}
\details{
The function takes as input the output of the function 
\code{tblPlotPCALoadings}. It uses the \code{ggplotly} function from 
\code{plotly} to create an interactive \code{plotly} plot.
}
\examples{
x <- matrix(rnorm(seq_len(10000)), ncol = 100)
rownames(x) <- paste("feature", seq_len(nrow(x)))
colnames(x) <- paste("sample", seq_len(ncol(x)))
params <- list(method = "euclidean", ## dist
    initial_dims = 10, max_iter = 100, dims = 3, perplexity = 3, ## tSNE
    min_dist = 0.1, n_neighbors = 15, spread = 1) ## UMAP
tbl <- tblPCALoadings(x, params)
plotPCALoadings(tbl, x_coord = "PC1", y_coord = "PC2")

}
\author{
Thomas Naake
}
