% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_measuredvalues_missingvalues.R
\name{histFeatureCategory}
\alias{histFeatureCategory}
\title{Histogram of features per sample type}
\usage{
histFeatureCategory(se, measured = TRUE, category = "type", ...)
}
\arguments{
\item{se}{\code{SummarizedExperiment}, the assay slot contains the intensity 
values per sample. Missing values are encoded as \code{NA}.}

\item{measured}{\code{logical}, should the measured values 
(\code{measured = TRUE}) or missing values (\code{measured = FALSE}) be taken}

\item{category}{\code{character}, corresponding to a column in 
\code{colData(se)}}

\item{...}{additional parameters passed to \code{geom_histogram}, e.g. 
\code{binwidth}.}
}
\value{
\code{plotly} object from \code{ggplotly}
}
\description{
The function \code{histFeatureCategory} creates histogram
plots for each sample type in \code{se}.
}
\examples{
## create se
a <- matrix(seq_len(100), nrow = 10, ncol = 10, 
            dimnames = list(seq_len(10), paste("sample", seq_len(10))))
a[c(1, 5, 8), seq_len(5)] <- NA
set.seed(1)
a <- a + rnorm(100)
cD <- data.frame(name = colnames(a), type = c(rep("1", 5), rep("2", 5)))
rD <- data.frame(spectra = rownames(a))
se <- SummarizedExperiment::SummarizedExperiment(assay = a, 
    rowData = rD, colData = cD)

histFeatureCategory(se, measured = TRUE, category = "type")

}
