% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prioritize.R
\name{prioritize}
\alias{prioritize}
\title{Rank metabolic features and prioritize based on predicted bioactivity.}
\usage{
prioritize(se, mod.assn, mac.ava, mac.qval, mac.es)
}
\arguments{
\item{se}{SummarizedExperiment object created using Macarron::prepInput()}

\item{mod.assn}{the output of Macarron::findMacMod()}

\item{mac.ava}{the output of Macarron::calAVA()}

\item{mac.qval}{the output of Macarron::calQval()}

\item{mac.es}{the output of Macarron::calES()}
}
\value{
mac.result - metabolic features listed according to priority
}
\description{
Metabolic features are ranked based on AVA, and q-value and effect size of
differential abundance. The harmonic mean of these three ranks is calculated and used as 
the meta-rank to prioritize potentially bioactive features in a phenotype (or condition). 
Top-ranked features have good relative abundance, and are significantly perturbed 
in the specified environment/phenotype.
}
\examples{
prism_abundances = system.file("extdata", "demo_abundances.csv", package="Macarron")
abundances_df = read.csv(file = prism_abundances, row.names = 1)
prism_annotations = system.file("extdata", "demo_annotations.csv", package="Macarron")
annotations_df = read.csv(file = prism_annotations, row.names = 1)
prism_metadata = system.file("extdata", "demo_metadata.csv", package="Macarron")
metadata_df = read.csv(file = prism_metadata, row.names = 1)
met_taxonomy = system.file("extdata", "demo_taxonomy.csv", package="Macarron")
taxonomy_df = read.csv(file = met_taxonomy)
mbx <- Macarron::prepInput(input_abundances = abundances_df,
                            input_annotations = annotations_df,
                            input_metadata = metadata_df)
w <- Macarron::makeDisMat(se = mbx)
modules.assn <- Macarron::findMacMod(se = mbx, 
                                     w = w,
                                     input_taxonomy = taxonomy_df)
mets.ava <- Macarron::calAVA(se = mbx,
                             mod.assn = modules.assn)                                     
mets.qval <- Macarron::calQval(se = mbx,
                               mod.assn = modules.assn)
mets.es <- Macarron::calES(se = mbx,
                           mac.qval = mets.qval)
mets.prioritized <- Macarron::prioritize(se = mbx,
                                         mod.assn = modules.assn,
                                         mac.ava = mets.ava,
                                         mac.qval = mets.qval,
                                         mac.es = mets.es)                         


}
