% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeDisMat.R
\name{makeDisMat}
\alias{makeDisMat}
\title{Create a biweight midcorrelation (WGCNA::bicor()) based distance matrix.}
\usage{
makeDisMat(
  se,
  metadata_variable = 1,
  min_prevalence = 0.7,
  execution_mode = "serial",
  optimize.for = c("runtime", "memory")
)
}
\arguments{
\item{se}{SummarizedExperiment object created using Macarron::prepInput().}

\item{metadata_variable}{metadata column identifying phenotypes/conditions to be used to evaluate prevalence of features. Default = Column 1 of metadata dataframe.}

\item{min_prevalence}{prevalence threshold (percentage). Default = 0.7.}

\item{execution_mode}{"serial" or "multi" processing with BiocParallel. Default: "serial" (recommended for laptops). 
"multi" may be used when running Macarron on a cluster.}

\item{optimize.for}{runtime or memory.

Features present (i.e. not NA) in "min_prevalence" of samples in each category of a "metadata_variable" will be considered 
e.g. if min_prevalence is 0.7 and metadata_variable has 2 categories A and B, union of (i) features present in at least 70% of A samples
and (ii) features present in at least 70% of B samples, will be considered for distance matrix generation. 
Correlation between feature abundances are is calculated using WGCNA::bicor().}
}
\value{
w distance matrix where distance = 1-bicor^3
}
\description{
Create a biweight midcorrelation (WGCNA::bicor()) based distance matrix.
}
\examples{
prism_abundances = system.file("extdata", "demo_abundances.csv", package="Macarron")
abundances_df = read.csv(file = prism_abundances, row.names = 1)
prism_annotations = system.file("extdata", "demo_annotations.csv", package="Macarron")
annotations_df = read.csv(file = prism_annotations, row.names = 1)
prism_metadata = system.file("extdata", "demo_metadata.csv", package="Macarron")
metadata_df = read.csv(file = prism_metadata, row.names = 1)
mbx <- Macarron::prepInput(input_abundances = abundances_df,
                            input_annotations = annotations_df,
                            input_metadata = metadata_df)
w <- Macarron::makeDisMat(se = mbx)


}
