% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decorateID.R
\name{decorateID}
\alias{decorateID}
\title{Create a chemical taxonomy table for annotated metabolic features.}
\usage{
decorateID(input_annotations)
}
\arguments{
\item{input_annotations}{a dataframe (features x annotations) containing the available feature annotations.
^^Column 1 must contain standard annotations such as HMDB ID or PubChem CID for 
the subset of identified/annotated metabolic features.}
}
\value{
tax_df input_taxonomy-dataframe containing ID (HMDB or PubChem), chemical sub class and chemical class of annotated metabolic features.
}
\description{
Create a chemical taxonomy table for annotated metabolic features.
}
\examples{
prism_annotations = system.file("extdata", "demo_annotations.csv", package="Macarron")
annotations_df = read.csv(file = prism_annotations, row.names = 1)
input_taxonomy <- decorateID(annotations_df)

}
