% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calES.R
\name{calES}
\alias{calES}
\title{Calculate effect size of differential abundance of metabolic features.}
\usage{
calES(se, mac.qval)
}
\arguments{
\item{se}{SummarizedExperiment object created using Macarron::prepInput().}

\item{mac.qval}{the output of Macarron::calQval().}
}
\value{
mac.es effect sizes of metabolic features in phenotypes of interest.
}
\description{
Effect size of a metabolic feature is the difference in mean log2 transformed abundances in 
test and control (reference) samples. For the specified metadata variable, effect size 
is calculated for all test categories against the reference category.
}
\examples{
prism_abundances = system.file("extdata", "demo_abundances.csv", package="Macarron")
abundances_df = read.csv(file = prism_abundances, row.names = 1)
prism_annotations = system.file("extdata", "demo_annotations.csv", package="Macarron")
annotations_df = read.csv(file = prism_annotations, row.names = 1)
prism_metadata = system.file("extdata", "demo_metadata.csv", package="Macarron")
metadata_df = read.csv(file = prism_metadata, row.names = 1)
met_taxonomy = system.file("extdata", "demo_taxonomy.csv", package="Macarron")
taxonomy_df = read.csv(file = met_taxonomy)
mbx <- Macarron::prepInput(input_abundances = abundances_df,
                            input_annotations = annotations_df,
                            input_metadata = metadata_df)
w <- Macarron::makeDisMat(se = mbx)
modules.assn <- Macarron::findMacMod(se = mbx, 
                                     w = w,
                                     input_taxonomy = taxonomy_df)
mets.qval <- Macarron::calQval(se = mbx,
                               mod.assn = modules.assn)
mets.es <- Macarron::calES(se = mbx,
                           mac.qval = mets.qval)                               

}
