% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/converters.R
\name{SpectroMinetoMSstatsTMTFormat}
\alias{SpectroMinetoMSstatsTMTFormat}
\title{Import data from SpectroMine}
\usage{
SpectroMinetoMSstatsTMTFormat(
  input,
  annotation,
  filter_with_Qvalue = TRUE,
  qvalue_cutoff = 0.01,
  useUniquePeptide = TRUE,
  rmPSM_withfewMea_withinRun = TRUE,
  rmProtein_with1Feature = FALSE,
  summaryforMultipleRows = sum,
  use_log_file = TRUE,
  append = FALSE,
  verbose = TRUE,
  log_file_path = NULL,
  ...
)
}
\arguments{
\item{input}{data name of SpectroMine PSM output. Read PSM sheet.}

\item{annotation}{data frame which contains column Run, Fraction, TechRepMixture, Mixture, Channel, BioReplicate, Condition. Refer to the example 'annotation.mine' for the meaning of each column.}

\item{filter_with_Qvalue}{TRUE(default) will filter out the intensities that have greater than qvalue_cutoff in EG.Qvalue column. Those intensities will be replaced with NA and will be considered as censored missing values for imputation purpose.}

\item{qvalue_cutoff}{Cutoff for EG.Qvalue. default is 0.01.}

\item{useUniquePeptide}{TRUE(default) removes peptides that are assigned for more than one proteins. We assume to use unique peptide for each protein.}

\item{rmPSM_withfewMea_withinRun}{TRUE (default) will remove the features that have 1 or 2 measurements within each Run.}

\item{rmProtein_with1Feature}{TRUE will remove the proteins which have only 1 peptide and charge. Defaut is FALSE.}

\item{summaryforMultipleRows}{sum(default) or max - when there are multiple measurements for certain feature in certain run, select the feature with the largest summation or maximal value.}

\item{use_log_file}{logical. If TRUE, information about data processing
will be saved to a file.}

\item{append}{logical. If TRUE, information about data processing will be added
to an existing log file.}

\item{verbose}{logical. If TRUE, information about data processing wil be printed
to the console.}

\item{log_file_path}{character. Path to a file to which information about 
data processing will be saved. 
If not provided, such a file will be created automatically.
If `append = TRUE`, has to be a valid path to a file.}

\item{...}{additional parameters to `data.table::fread`.}
}
\value{
`data.frame` of class `MSstatsTMT`
}
\description{
Import data from SpectroMine
}
\examples{
head(raw.mine)
head(annotation.mine)
input.mine <- SpectroMinetoMSstatsTMTFormat(raw.mine, annotation.mine)
head(input.mine)

}
