% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IC50_prediction_datatable.R
\name{predictIC50Parallel}
\alias{predictIC50Parallel}
\title{Parallel version of predictIC50 function}
\usage{
predictIC50Parallel(
  data,
  n_samples = 1000,
  alpha = 0.1,
  increasing = FALSE,
  transform_dose = TRUE,
  ratio_response = TRUE,
  bootstrap = TRUE,
  numberOfCores = 2
)
}
\arguments{
\item{data}{A data frame with columns: protein, drug, dose, response.}

\item{n_samples}{Number of bootstrap samples. Default = 1000.}

\item{alpha}{Confidence level. Default = 0.10.}

\item{increasing}{Logical. If TRUE, fit non-decreasing trend. Default = FALSE.}

\item{transform_dose}{Logical. If TRUE, applies log10(dose + 1) transformation. Default = TRUE.}

\item{ratio_response}{Logical. If TRUE, use ratio response; else use log2 scale. Default = TRUE.}

\item{bootstrap}{Logical. If TRUE, compute bootstrap CIs. Default = TRUE.}

\item{numberOfCores}{Number of cores for parallel processing. Default = 2.}
}
\value{
A data frame with columns: protein, drug, IC50, lower CI, upper CI.
}
\description{
Runs predictIC50 on the entire dataset in parallel across proteins.
}
\examples{
# Load example data
data_path <- system.file("extdata", "DIA_MSstats_Normalized.RDS",
                         package = "MSstatsResponse")
dia_data <- readRDS(data_path)

# Convert GROUP to dose
dose_info <- convertGroupToNumericDose(dia_data$ProteinLevelData$GROUP)
dia_data$ProteinLevelData$dose <- dose_info$dose_nM * 1e-9
dia_data$ProteinLevelData$drug <- dose_info$drug

# Prepare data for analysis
prepared_data <- MSstatsPrepareDoseResponseFit(
  dia_data$ProteinLevelData,
  dose_column = "dose",
  drug_column = "drug",
  protein_column = "Protein",
  log_abundance_column = "LogIntensities"
)

# Subset for quick example
example_data <- prepared_data[prepared_data$protein \%in\%
                              unique(prepared_data$protein)[1:5], ]

# Example 1: Quick parallel IC50 without bootstrap (2 cores)
ic50_quick_parallel <- predictIC50Parallel(
  data = example_data,
  bootstrap = FALSE,
  numberOfCores = 2
)
print(ic50_quick_parallel)

}
