% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateProteolyticResistance.R
\name{calculateProteolyticResistance}
\alias{calculateProteolyticResistance}
\title{Calcutates proteolytic resistance for provided data. Requires input from
dataSummarizationLiP function. Can optionally calculate differential
analysis using proteolytic resistance. In order for this function to work,
Conditions and run numbers must match between the LiP and TrP
data.}
\usage{
calculateProteolyticResistance(
  LiP_data,
  fasta_file,
  differential_analysis = FALSE,
  contrast.matrix = "pairwise"
)
}
\arguments{
\item{LiP_data}{name of variable containing LiP data. Must be output of
dataSummarizationLiP function.}

\item{fasta_file}{name of variable containing FASTA data. If FASTA file has
not been processed please run the tidyFasta() function on it before inputting
into this function. Protein names in file must match those in LiP_data.}

\item{differential_analysis}{logical indicating whether to run differential
analysis. Default is FALSE. Conditions and run numbers must match between
the LiP and TrP data.}

\item{contrast.matrix}{either a string of "pairwise" or a matrix including
what comparisons to make in the differential analysis. Only required if
differential_analysis=TRUE. Default is "pairwise".}
}
\value{
a \code{data.frame} including either the summarized Proteolytic data or
differential analysis depending on parameter selection.
}
\description{
Calcutates proteolytic resistance for provided data. Requires input from
dataSummarizationLiP function. Can optionally calculate differential
analysis using proteolytic resistance. In order for this function to work,
Conditions and run numbers must match between the LiP and TrP
data.
}
\examples{
fasta <- tidyFasta(system.file("extdata", "ExampleFastaFile.fasta", package="MSstatsLiP"))
#calculateProteolyticResistance(MSstatsLiP_data, fasta)
}
