% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_ProteomeDiscoverer.R
\name{.cleanRawPDTMT}
\alias{.cleanRawPDTMT}
\title{Clean raw TMT data from Proteome Discoverer}
\usage{
.cleanRawPDTMT(
  msstats_object,
  remove_shared = TRUE,
  remove_protein_groups = TRUE,
  protein_id_column = "ProteinAccessions",
  intensity_columns_regexp = "Abundance",
  run_column = "SpectrumFile"
)
}
\arguments{
\item{msstats_object}{an object of class \code{MSstatsSpectroMineFiles}.}

\item{remove_shared}{lgl, if TRUE, shared peptides will be removed.}

\item{remove_protein_groups}{if TRUE, proteins with numProteins > 1 will be removed.}

\item{protein_id_column}{chr, name of a column with protein IDs.}

\item{intensity_columns_regexp}{regular expressions that defines intensity columns.
Defaults to "Abundance", which means that columns that contain the word "Abundance"
will be treated as corresponding to intensities for different channels.}
}
\value{
\code{data.table}
}
\description{
Clean raw TMT data from Proteome Discoverer
}
\keyword{internal}
