% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSubnetworkFromIndra.R
\name{getSubnetworkFromIndra}
\alias{getSubnetworkFromIndra}
\title{Get subnetwork from INDRA database}
\usage{
getSubnetworkFromIndra(
  input,
  protein_level_data = NULL,
  pvalueCutoff = NULL,
  statement_types = NULL,
  paper_count_cutoff = 1,
  evidence_count_cutoff = 1,
  correlation_cutoff = 0.3,
  sources_filter = NULL,
  logfc_cutoff = NULL,
  force_include_other = NULL,
  filter_by_curation = FALSE,
  api_key = ""
)
}
\arguments{
\item{input}{output of \code{\link[MSstats]{groupComparison}} function's 
comparisionResult table, which contains a list of proteins and their 
corresponding p-values, logFCs, along with additional HGNC ID and HGNC 
name columns}

\item{protein_level_data}{output of the \code{\link[MSstats]{dataProcess}} 
function's ProteinLevelData table, which contains a list of proteins and 
their corresponding abundances.  Used for annotating correlation information 
and applying correlation cutoffs.}

\item{pvalueCutoff}{p-value cutoff for filtering. Default is NULL, i.e. no
filtering}

\item{statement_types}{list of interaction types to filter on.  Equivalent to
statement type in INDRA.  Default is NULL.}

\item{paper_count_cutoff}{number of papers to filter on. Default is 1.}

\item{evidence_count_cutoff}{number of evidence to filter on for each
paper. E.g. A paper may have 5 sentences describing the same interaction vs 1
sentence.  Default is 1.}

\item{correlation_cutoff}{if protein_level_abundance is not NULL, apply a 
cutoff for edges with correlation less than a specified cutoff.  Default is
0.3}

\item{sources_filter}{filtering only on specific sources.  Default is no filter, i.e. NULL.
Otherwise, should be a list, e.g. c('reach', 'medscan').}

\item{logfc_cutoff}{absolute log fold change cutoff for filtering proteins. 
Only proteins with |logFC| greater than this value will be retained. Default 
is NULL, i.e. no logFC filtering.}

\item{force_include_other}{character vector of identifiers to include in the
network, regardless if those ids are in the input data. Should be formatted
as "namespace:identifier", e.g. "HGNC:1234" or "CHEBI:4911".}

\item{filter_by_curation}{logical, whether to filter out statements that
have been curated as incorrect in INDRA.  Default is FALSE.}

\item{api_key}{string of INDRA API key for accessing curated statements.}
}
\value{
list of 2 data.frames, nodes and edges
}
\description{
Using differential abundance results from MSstats, this function retrieves
a subnetwork of protein interactions from INDRA database.
}
\examples{
input <- data.table::fread(system.file(
    "extdata/groupComparisonModel.csv",
    package = "MSstatsBioNet"
))
subnetwork <- getSubnetworkFromIndra(input)
head(subnetwork$nodes)
head(subnetwork$edges)

}
