% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions-MSnSet.R
\name{nFeatures}
\alias{nFeatures}
\title{How many features in a group?}
\usage{
nFeatures(object, fcol)
}
\arguments{
\item{object}{An instance of class \code{MSnSet}.}

\item{fcol}{Feature variable defining the feature grouping
structure.}
}
\value{
An updated \code{MSnSet} with a new feature variable
\code{fcol.nFeatures}.
}
\description{
This function computes the number of features in the group defined
by the feature variable \code{fcol} and appends this information
in the feature data of \code{object}.
}
\examples{
library(pRolocdata)
data("hyperLOPIT2015ms3r1psm")
hyperLOPIT2015ms3r1psm <- nFeatures(hyperLOPIT2015ms3r1psm,
                                    "Protein.Group.Accessions")
i <- c("Protein.Group.Accessions", "Protein.Group.Accessions.nFeatures")
fData(hyperLOPIT2015ms3r1psm)[1:10, i]
}
\author{
Laurent Gatto
}
