% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions-MSnExp.R
\name{estimateMzScattering}
\alias{estimateMzScattering}
\title{Estimate m/z scattering in consecutive scans}
\usage{
estimateMzScattering(x, halfWindowSize = 1L, timeDomain = FALSE)
}
\arguments{
\item{x}{\code{MSnExp} or \code{OnDiskMSnExp} object.}

\item{halfWindowSize}{\code{integer(1)} defining the half window size for the
moving window to combine consecutive spectra.}

\item{timeDomain}{\code{logical(1)} whether m/z scattering should be estimated
on \code{mz} (\code{timeDomain = FALSE}) or \code{sqrt(mz)} (\code{timeDomain = TRUE})
values. See \code{\link[=combineSpectraMovingWindow]{combineSpectraMovingWindow()}} for details on this
parameter.}
}
\description{
Estimate scattering of m/z values (due to technical, instrument specific
noise) for the same ion in consecutive scans of a LCMS experiment.
}
\details{
The m/z values of the same ions in consecutive scans (spectra) of a LCMS run
will not be identical. This random noise is expected to be smaller than the
resolution of the MS instrument. The distribution of differences of m/z
values from neighboring spectra is thus expected to be (at least) bi-modal
with the first peak representing the above described random variation and
the second (or largest) peak the m/z resolution. The m/z value of the first
local minimum between these first two peaks in the distribution is returned
as the \emph{m/z scattering}.
}
\note{
For \code{timeDomain = TRUE} the function does \strong{not} return the estimated
scattering of m/z values, but the scattering of \code{sqrt(mz)} values.
}
\examples{

library(MSnbase)
library(msdata)
## Load a profile-mode LC-MS data file
f <- dir(system.file("sciex", package = "msdata"), full.names = TRUE)[1]
od <- readMSData(f, mode = "onDisk")
im <- as(filterRt(od, c(10, 20)), "MSnExp")

res <- estimateMzScattering(im)

## Plot the distribution of estimated m/z scattering
plot(density(unlist(res)))

## Compare the m/z resolution and m/z scattering of the spectrum with the
## most peaks
idx <- which.max(unlist(spectrapply(im, peaksCount)))

res[[idx]]
abline(v = res[[idx]], lty = 2)
estimateMzResolution(im[[idx]])
## As expected, the m/z scattering is much lower than the m/z resolution.
}
\seealso{
\code{\link[=estimateMzResolution]{estimateMzResolution()}} for the function to estimate a
profile-mode spectrum's m/z resolution from it's data.
}
\author{
Johannes Rainer
}
