% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-MSnExp.R, R/methods-Spectrum.R
\name{estimateMzResolution,MSnExp-method}
\alias{estimateMzResolution,MSnExp-method}
\alias{estimateMzResolution,Spectrum-method}
\alias{estimateMzResolution}
\title{Estimate the m/z resolution of a spectrum}
\usage{
\S4method{estimateMzResolution}{MSnExp}(object, ...)

\S4method{estimateMzResolution}{Spectrum}(object, ...)
}
\arguments{
\item{object}{either a \code{Spectrum}, \code{MSnExp} or \code{OnDiskMSnExp} object.}

\item{...}{currently not used.}
}
\value{
\code{numeric(1)} with the m/z resolution. If called on a \code{MSnExp} or
\code{OnDiskMSnExp} a \code{list} of m/z resolutions are returned (one for
each spectrum).
}
\description{
\code{estimateMzResolution} estimates the m/z resolution of a profile-mode
\code{Spectrum} (or of all spectra in an \link{MSnExp} or \link{OnDiskMSnExp} object.
The m/z resolution is defined as the most frequent difference between a
spectrum's m/z values.
}
\note{
This assumes the data to be in profile mode and does not return meaningful
results for centroided data.

The estimated m/z resolution depends on the number of ions detected in a
spectrum, as some instrument don't measure (or report) signal if below a
certain threshold.
}
\examples{

## Load a profile mode example file
library(BiocParallel)
register(SerialParam())
library(msdata)
f <- proteomics(full.names = TRUE,
    pattern = "TMT_Erwinia_1uLSike_Top10HCD_isol2_45stepped_60min_01.mzML.gz")

od <- readMSData(f, mode = "onDisk")

## Estimate the m/z resolution on the 3rd spectrum.
estimateMzResolution(od[[3]])

## Estimate the m/z resolution for each spectrum
mzr <- estimateMzResolution(od)

## plot the distribution of estimated m/z resolutions. The bimodal
## distribution represents the m/z resolution of the MS1 (first peak) and
## MS2 spectra (second peak).
plot(density(unlist(mzr)))
}
\author{
Johannes Rainer
}
