% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{msFilter}
\alias{msFilter}
\title{Function for filtering abundance data set.}
\usage{
msFilter(
  data,
  filterPercent = 0.8,
  compVars = c("mz", "rt"),
  sampleVars = c("subject_id"),
  colExtraText = NULL,
  separator = NULL,
  missingValue = NA,
  returnToSE = FALSE,
  returnToDF = FALSE
)
}
\arguments{
\item{data}{Data set as either a data frame or `SummarizedExperiement`.}

\item{filterPercent}{Decimal value indicating filtration threshold. 
Compounds which are present in fewer samples than the specified proportion 
will be removed.}

\item{compVars}{Vector of the columns which identify compounds. If a 
`SummarizedExperiment` is used for `data`, row variables will be used.}

\item{sampleVars}{Vector of the ordered sample variables found in each sample
column.}

\item{colExtraText}{Any extra text to ignore at the beginning of the sample 
columns names. Unused for `SummarizedExperiments`.}

\item{separator}{Character or text separating each sample variable in sample
columns. Unused for `SummarizedExperiment`.}

\item{missingValue}{Specifies the abundance value which indicates missing 
data. May be a numeric or `NA`.}

\item{returnToSE}{Logical value indicating whether to return as 
`SummarizedExperiment`}

\item{returnToDF}{Logical value indicating whether to return as data frame.}
}
\value{
A data frame or `SummarizedExperiment` with filtered abundance data.
Default return type is set to match the data input but may be altered with 
the `returnToSE` or `returnToDF` arguments.
}
\description{
Filters compounds to those found in specified proportion of samples.
}
\examples{

# Load example data set, summarize replicates
data(msquant)

summarizedDF <- msSummarize(msquant,
                            compVars = c("mz", "rt"),
                            sampleVars = c("spike", "batch", "replicate", 
                            "subject_id"),
                            cvMax = 0.50,
                            minPropPresent = 1/3,
                            colExtraText = "Neutral_Operator_Dif_Pos_",
                            separator = "_",
                            missingValue = 1)

# Filter the dataset using a 80\% filter rate
filteredDF <- msFilter(summarizedDF,
                       filterPercent = 0.8,
                       compVars = c("mz", "rt"),
                       sampleVars = c("spike", "batch", "subject_id"),
                       separator = "_")


}
