data(hiv)

test_that("cds2codonaln() outputs DNAStringSet", {
    cds1 <- Biostrings::DNAString("ATGCAACATTGC")
    cds2 <- Biostrings::DNAString("ATGCATTGC")
    cds1.cds2.aln <- cds2codonaln(cds1, cds2)
    expect_true(as.character(cds1.cds2.aln[1]) == "ATGCAACATTGC")
    expect_true(as.character(cds1.cds2.aln[2]) == "ATG---CATTGC")
    cds1.cds2.aln.rem <- cds2codonaln(cds1, cds2, remove.gaps=TRUE)
    expect_true(as.character(cds1.cds2.aln.rem[1]) == "ATGCATTGC")
    expect_true(as.character(cds1.cds2.aln.rem[2]) == "ATGCATTGC")
    cds1.cds2.aln.local <- cds2codonaln(cds1, cds2, type="local")
    expect_true(as.character(cds1.cds2.aln.local[1]) == "CAACATTGC")
    expect_true(as.character(cds1.cds2.aln.local[2]) == "ATGCATTGC")
})
