% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rcpp_KaKs}
\alias{rcpp_KaKs}
\title{rcpp_KaKs}
\usage{
rcpp_KaKs(cdsstr, sgc = "1", method = "YN", verbose = FALSE)
}
\arguments{
\item{cdsstr}{StringVector [mandatory]}

\item{sgc}{standard genetic code to use [default: 1]}

\item{method}{KaKs Calculator 2.0 codon model [default: YN]}

\item{verbose}{specify if verbose output [default: FALSE]}
}
\value{
\code{list}
}
\description{
calculates KaKs as implememted in
KaKs Calculator 2.0 \code{MSA2dist} with \code{Rcpp}.
}
\examples{
## load example sequence data
data("hiv", package="MSA2dist")
rcpp_KaKs(cdsstr=as.character(hiv[1:3]))
}
\references{
Wang et al. (2010) KaKs_Calculator 2.0: a toolkit incorporating
gamma-series methods and sliding window strategies.\emph{Genomics,
proteomics & bioinformatics.} \bold{8(1)}, 77-80.
}
\author{
Kristian K Ullrich
}
