% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popinteger.R
\name{popinteger}
\alias{popinteger}
\title{popinteger}
\usage{
popinteger(seq)
}
\arguments{
\item{seq}{\code{DNAStringSet} or \code{AAStringSet} [mandatory]}
}
\value{
population integer from \code{metadata}
}
\description{
This function shows the population integer slot from a
\code{DNAStringSet} or an \code{AAStringSet}
\code{metadata} information.\cr
}
\examples{
## load example sequence data
data(iupac, package="MSA2dist")
iupac.aa <- iupac |> cds2aa(shorten = TRUE)
## create poplist
poplist <- list(FRA = grep("Mmd.FRA", names(iupac)),
    GER = grep("Mmd.GER", names(iupac)),
    IRA = grep("Mmd.IRA", names(iupac)),
    AFG = grep("Mmm.AFG", names(iupac)))
iupac.aa <- iupac.aa |> addpop2string(poplist)
popinteger(iupac.aa)
}
\seealso{
\code{\link[MSA2dist]{addpop2string}}
}
\author{
Kristian K Ullrich
}
