% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pal2nal.R
\name{pal2nal}
\alias{pal2nal}
\title{pal2nal}
\usage{
pal2nal(pal, nal, remove.gaps = FALSE)
}
\arguments{
\item{pal}{\code{AAStringSet} [mandatory]}

\item{nal}{\code{DNAStringSet} [mandatory]}

\item{remove.gaps}{specify if gaps in the codon alignment should be removed
[default: FALSE]}
}
\value{
codon alignment as \code{DNAStringSet}
}
\description{
This function takes an \code{AAStringSet} alignment and
its corresponding coding sequences \code{DNAStringSet} and converts
the protein alignment into a codon alignment.
}
\examples{
## define two cds sequences
cds <- Biostrings::DNAStringSet(c("ATGCAACATTGC", "ATGCATTGC"))
names(cds) <- c("cds1", "cds2")
## get protein alignment
aa <- MSA2dist::cds2aa(cds)
msa <- makePostalignedSeqs(pwalign::pairwiseAlignment(aa[1], aa[2]))[[1L]]
names(msa) <- names(aa)
## get codon alignment
nal <- MSA2dist::pal2nal(pal=msa, nal=cds)
nal
}
\references{
Pagès, H et al. (2014) Biostrings: Efficient manipulation of
biological strings. \emph{R package version}, \bold{2(0)}.
}
\seealso{
\code{\link[pwalign]{pairwiseAlignment}}
}
\author{
Kristian K Ullrich
}
